using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.IO;
using System.Windows.Forms;
using Microsoft.Win32;

namespace SID_monitor
{
    public partial class PanelStartup : UserControl
    {
        public PanelStartup()
        {
            InitializeComponent();

            this.checkBoxAutoStartup.Checked = this.IsAutoStartSet();

            this.checkBoxStartMinimized.Checked = SID_monitor.Properties.Settings.Default.StartMinimized;
            this.checkBoxMinimizeToTray.Checked = SID_monitor.Properties.Settings.Default.MinimizeToTray;

        }

        public bool IsAutoStartSet()
        {
            string regKey = (string)Registry.GetValue("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Run", "SID_monitor", String.Empty);
            //if ( String.IsNullOrEmpty(regKey) )
            //{
            //    return false;
            //}
            
            regKey = regKey.Trim(Path.GetInvalidFileNameChars()).Trim(Path.GetInvalidPathChars()); // used mainly to remove double quoptes between the path
            
            // Is the path identified in the key identical to the current application?
            if ((!String.IsNullOrEmpty(regKey)) && (Path.Equals(Path.GetFullPath(regKey), Path.GetFullPath(Application.ExecutablePath))))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        #region Properties
        public bool AutoStartup
        {
            get
            {
                return this.checkBoxAutoStartup.Checked;
            }
        }

        public bool StartMinimized
        {
            get
            {
                return this.checkBoxStartMinimized.Checked;
            }
        }

        public bool MinimizeToTray
        {
            get
            {
                return this.checkBoxMinimizeToTray.Checked;
            }
        }
        #endregion

        #region ValidData Event
        public event SID_monitor.ValidDataEventHandler ValidData;

        protected virtual void OnValidData(SID_monitor.validDataEventArgs e)
        {
            if (ValidData != null)
            {
                // Invokes the delegates. 
                ValidData(this, e);
            }
        }
        #endregion

      
    }
}
